/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.entity;

import dev.xkmc.curseofpandora.init.registrate.CoPEntities;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class EvilSpirit
extends PathfinderMob
implements TraceableEntity,
OwnableEntity {
    public static final float FLAP_DEGREES_PER_TICK = 45.836624f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)3.9269907f);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(EvilSpirit.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_IS_CHARGING = 1;
    private static final double RIDING_OFFSET = 0.4;
    @Nullable
    UUID owner;
    @Nullable
    private BlockPos boundOrigin;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;

    public EvilSpirit(EntityType<? extends EvilSpirit> type, Level level) {
        super(type, level);
        this.f_21342_ = new VexMoveControl(this);
    }

    public EvilSpirit(Player player) {
        this((EntityType<? extends EvilSpirit>)((EntityType)CoPEntities.EVIL_SPIRIT.get()), player.m_9236_());
        this.setOwner(player);
        this.m_146884_(player.m_20182_());
    }

    @Nullable
    public UUID m_21805_() {
        return this.owner;
    }

    public void setOwner(Player player) {
        this.owner = player.m_20148_();
    }

    @Nullable
    public Player getOwner() {
        return this.owner == null ? null : this.m_9236_().m_46003_(this.owner);
    }

    public boolean m_7307_(Entity entity) {
        Player player = this.getOwner();
        if (player != null) {
            if (player == entity) {
                return true;
            }
            if (player.m_7307_(entity)) {
                return true;
            }
        }
        return super.m_7307_(entity);
    }

    protected float m_6431_(Pose pose, EntityDimensions dim) {
        return dim.f_20378_ - 0.28125f;
    }

    public boolean m_142039_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public void m_6478_(MoverType type, Vec3 dir) {
        super.m_6478_(type, dir);
        this.m_20101_();
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.m_6469_(this.m_269291_().m_269064_(), this.m_21233_());
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new VexChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new VexRandomMoveGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(tag.m_128451_("BoundX"), tag.m_128451_("BoundY"), tag.m_128451_("BoundZ"));
        }
        if (tag.m_128441_("LifeTicks")) {
            this.setLimitedLife(tag.m_128451_("LifeTicks"));
        }
        if (tag.m_128441_("Owner")) {
            this.owner = tag.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.boundOrigin != null) {
            tag.m_128405_("BoundX", this.boundOrigin.m_123341_());
            tag.m_128405_("BoundY", this.boundOrigin.m_123342_());
            tag.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
        if (this.hasLimitedLife) {
            tag.m_128405_("LifeTicks", this.limitedLifeTicks);
        }
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pos) {
        this.boundOrigin = pos;
    }

    private boolean getVexFlag(int flag) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & flag) != 0;
    }

    private void setVexFlag(int flag, boolean val) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = val ? (i |= flag) : (i &= ~flag);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean charge) {
        this.setVexFlag(1, charge);
    }

    public void setLimitedLife(int life) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = life;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12499_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12502_;
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance ins, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        RandomSource randomsource = level.m_213780_();
        this.m_213945_(randomsource, ins);
        this.m_213946_(randomsource, ins);
        return super.m_6518_(level, ins, type, data, tag);
    }

    protected void m_213945_(RandomSource source, DifficultyInstance ins) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public double m_6049_() {
        return 0.4;
    }

    public void m_8107_() {
        this.m_21203_();
        this.updateNoActionTime();
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_6084_()) {
            return;
        }
        Player owner = this.getOwner();
        if (owner == null) {
            return;
        }
        target = owner.m_21188_();
        if (target != null && target.m_6084_()) {
            return;
        }
        this.m_6710_(target);
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public boolean m_6149_() {
        return false;
    }

    protected boolean m_6125_() {
        return false;
    }

    public ItemStack m_6298_(ItemStack weapon) {
        if (weapon.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)weapon.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)weapon, (ItemStack)(itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack));
        }
        return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)weapon, (ItemStack)ItemStack.f_41583_);
    }

    class VexMoveControl
    extends MoveControl {
        public VexMoveControl(EvilSpirit p_34062_) {
            super((Mob)p_34062_);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - EvilSpirit.this.m_20185_(), this.f_24976_ - EvilSpirit.this.m_20186_(), this.f_24977_ - EvilSpirit.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < EvilSpirit.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    EvilSpirit.this.m_20256_(EvilSpirit.this.m_20184_().m_82490_(0.5));
                } else {
                    EvilSpirit.this.m_20256_(EvilSpirit.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (EvilSpirit.this.m_5448_() == null) {
                        Vec3 vec31 = EvilSpirit.this.m_20184_();
                        EvilSpirit.this.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        EvilSpirit.this.f_20883_ = EvilSpirit.this.m_146908_();
                    } else {
                        double d2 = EvilSpirit.this.m_5448_().m_20185_() - EvilSpirit.this.m_20185_();
                        double d1 = EvilSpirit.this.m_5448_().m_20189_() - EvilSpirit.this.m_20189_();
                        EvilSpirit.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        EvilSpirit.this.f_20883_ = EvilSpirit.this.m_146908_();
                    }
                }
            }
        }
    }

    class VexChargeAttackGoal
    extends Goal {
        public VexChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = EvilSpirit.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && !EvilSpirit.this.m_21566_().m_24995_();
        }

        public boolean m_8045_() {
            return EvilSpirit.this.m_21566_().m_24995_() && EvilSpirit.this.isCharging() && EvilSpirit.this.m_5448_() != null && EvilSpirit.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = EvilSpirit.this.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                EvilSpirit.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            EvilSpirit.this.setIsCharging(true);
            EvilSpirit.this.m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
        }

        public void m_8041_() {
            EvilSpirit.this.setIsCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = EvilSpirit.this.m_5448_();
            if (livingentity != null) {
                if (EvilSpirit.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    EvilSpirit.this.m_7327_((Entity)livingentity);
                    EvilSpirit.this.setIsCharging(false);
                } else {
                    double d0 = EvilSpirit.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.m_146892_();
                        EvilSpirit.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    class VexRandomMoveGoal
    extends Goal {
        public VexRandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !EvilSpirit.this.m_21566_().m_24995_() && EvilSpirit.this.f_19796_.m_188503_(VexRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = EvilSpirit.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = EvilSpirit.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(EvilSpirit.this.f_19796_.m_188503_(15) - 7, EvilSpirit.this.f_19796_.m_188503_(11) - 5, EvilSpirit.this.f_19796_.m_188503_(15) - 7);
                if (!EvilSpirit.this.m_9236_().m_46859_(blockpos1)) continue;
                EvilSpirit.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (EvilSpirit.this.m_5448_() != null) break;
                EvilSpirit.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

